/*
 * Decompiled with CFR 0.152.
 */
package de.adwin.driver;

import de.adwin.driver.ADwinDirectDevice;
import de.adwin.driver.DataToArrayConverter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class DataToFloatArray
extends DataToArrayConverter {
    protected float[] Array;

    DataToFloatArray(int Size, int SourceType) {
        super(Size);
        this.Array = new float[Size];
        this.SourceType = SourceType;
    }

    float[] getArray() {
        return this.Array;
    }

    @Override
    void storeBytesImpl(byte[] Bytes, int BytesIndex, int IndexStart, int Amount) {
        switch (this.SourceType) {
            case 2: 
            case 3: {
                for (int i = 0; i < Amount; ++i) {
                    this.Array[IndexStart + i] = ADwinDirectDevice.extractInt(Bytes, BytesIndex + i * 4);
                }
                break;
            }
            case 5: {
                for (int i = 0; i < Amount; ++i) {
                    this.Array[IndexStart + i] = Float.intBitsToFloat(ADwinDirectDevice.extractInt(Bytes, BytesIndex + i * 4));
                }
                break;
            }
            case 6: {
                for (int i = 0; i < Amount; ++i) {
                    this.Array[IndexStart + i] = (float)ByteBuffer.wrap(Bytes, BytesIndex + i * 8, 8).order(ByteOrder.LITTLE_ENDIAN).getDouble();
                }
                break;
            }
            case 7: {
                for (int i = 0; i < Amount; ++i) {
                    this.Array[IndexStart + i] = ByteBuffer.wrap(Bytes, BytesIndex + i * 8, 8).order(ByteOrder.LITTLE_ENDIAN).getLong();
                }
                break;
            }
        }
    }
}

