/*
 * Decompiled with CFR 0.152.
 */
package de.adwin.driver;

import de.adwin.driver.ADwinCommunicationError;
import de.adwin.driver.ADwinDebugListener;
import de.adwin.driver.ADwinDirectDevice;
import de.adwin.driver.NamedMutex;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;

public class ADwinDevice {
    public static final int LANGID_ENGLISH = 1;
    public static final int LANGID_GERMAN = 2;
    public static final int LANGID_SYSDEFAULT = 0;
    private static final HashMap Devices = new HashMap();
    private int LangID;
    private NamedMutex nm = null;
    private int CurrentDeviceNo = 0;
    private ADwinDirectDevice add = null;
    private boolean UseFileLocks = false;
    private int NAN_test = 1;

    public ADwinDevice() {
        try {
            this.LangID = Locale.getDefault().getISO3Language().compareTo("deu") != 0 ? 1 : 2;
        }
        catch (MissingResourceException mre) {
            this.LangID = 1;
        }
    }

    public void Add_Entry(int deviceNo, InetAddress ipAddressADwinSystem, String password, int tcpipServerDeviceNo, int port) {
        this.Add_Entry(deviceNo, ipAddressADwinSystem, password, 1000, 1000, 3, 20, 100, 5, tcpipServerDeviceNo, port);
    }

    public void Add_Entry(int deviceNo, InetAddress ipAddressADwinSystem, String password, int tcpipServerDeviceNo, int port, int networkTimeout) {
        this.Add_Entry(deviceNo, ipAddressADwinSystem, password, networkTimeout, networkTimeout, 3, 20, 100, 5, tcpipServerDeviceNo, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Add_Entry(int DevNo, InetAddress IP, String Password, int Timeout, int ADTimeout, int AllowedErrors, int NumWaits, int WaitTime, int Blocksize, int Hostlink, int Port) throws IllegalArgumentException {
        HashMap hashMap = Devices;
        synchronized (hashMap) {
            if (DevNo < 0) {
                throw new IllegalArgumentException("Only positive device numbers are allowed");
            }
            if (Devices.get(DevNo) != null) {
                throw new IllegalArgumentException("Device-No " + DevNo + " already exists");
            }
            Dev tmp = new Dev();
            tmp.IP = IP;
            tmp.Password = Password;
            tmp.Timeout = Timeout;
            tmp.ADTimeout = ADTimeout;
            tmp.AllowedErrors = AllowedErrors;
            tmp.NumWaits = NumWaits;
            tmp.WaitTime = WaitTime;
            tmp.Blocksize = Blocksize;
            tmp.Hostlink = Hostlink;
            tmp.Port = Port;
            Devices.put(DevNo, tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Remove_Entry(int DevNo) {
        HashMap hashMap = Devices;
        synchronized (hashMap) {
            return Devices.remove(DevNo) != null;
        }
    }

    public void Use_FileLocks(boolean Usage) throws ADwinCommunicationError {
        this.UseFileLocks = Usage;
        if (!this.UseFileLocks && this.nm != null) {
            this.nm.close();
            this.nm = null;
        } else if (this.UseFileLocks && this.nm == null && this.CurrentDeviceNo > 0) {
            this.nm = new NamedMutex(this.CurrentDeviceNo, this.LangID);
        }
    }

    public void Set_Language(int LanguageID) {
        try {
            this.LangID = LanguageID != 1 && LanguageID != 2 ? (Locale.getDefault().getISO3Language().compareTo("deu") != 0 ? 1 : 2) : LanguageID;
        }
        catch (MissingResourceException mre) {
            this.LangID = 1;
        }
        if (this.add != null) {
            this.add.Language = this.LangID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] Get_Known_DeviceNo() {
        int[] Devs;
        HashMap hashMap = Devices;
        synchronized (hashMap) {
            Object[] KeySet2 = Devices.keySet().toArray();
            Devs = new int[Devices.size()];
            for (int n = 0; n < Devs.length; ++n) {
                Devs[n] = (Integer)KeySet2[n];
            }
        }
        return Devs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Set_DeviceNo(int DevNo) throws ADwinCommunicationError {
        HashMap hashMap = Devices;
        synchronized (hashMap) {
            Dev d = (Dev)Devices.get(DevNo);
            if (d == null) {
                throw new IllegalArgumentException(this.LangID == 2 ? "Device " + DevNo + " nicht in der Device-Tabelle" : "Device " + DevNo + " is not in the device table");
            }
            if (this.UseFileLocks && this.CurrentDeviceNo != DevNo) {
                if (this.nm != null) {
                    this.nm.close();
                }
                this.nm = new NamedMutex(DevNo, this.LangID);
            }
            this.CurrentDeviceNo = DevNo;
            try {
                if (this.UseFileLocks) {
                    this.nm.enter();
                }
                this.add = new ADwinDirectDevice(d.IP, d.Port, d.Password, d.AllowedErrors, d.Timeout, d.Blocksize, d.ADTimeout, d.NumWaits, d.WaitTime, d.Hostlink);
            }
            catch (SocketException se) {
                throw new ADwinCommunicationError("The socket used to communicate with the ADwin system could not be created (" + se + ")", "Der Socket, der zur Kommunikation mit dem ADwin-System verwendet wird, konnte nicht erstellt werden (" + se + ")", this.LangID, 2000);
            }
            finally {
                if (this.UseFileLocks) {
                    this.nm.leave();
                }
            }
            this.add.Language = this.LangID;
        }
    }

    public int Get_DeviceNo() {
        return this.CurrentDeviceNo;
    }

    public int Get_Par(int Index) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        int Par = 0;
        try {
            Par = this.add.getPar(Index);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        return Par;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void GetData_Packed(int DataNo, int[] Data, int FirstIndex, int Count) throws ADwinCommunicationError, IllegalArgumentException, IndexOutOfBoundsException {
        if (Count == 0) {
            return;
        }
        if (Count < 0) {
            throw new IllegalArgumentException(this.LangID == 1 ? "Count must be > 0" : "Count muss > 0 sein");
        }
        if (Data.length < Count) {
            throw new IndexOutOfBoundsException(this.LangID == 1 ? "Data too small" : "Das Data ist zu klein");
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        int RealCount = Count / 2 + (FirstIndex % 2 | Count % 2);
        int RealFirstIndex = FirstIndex / 2;
        try {
            int[] IntData = this.add.getDataInt(DataNo, RealFirstIndex, RealFirstIndex + RealCount - 1);
            for (int n = 0; n < Count; ++n) {
                Data[n] = IntData[(FirstIndex % 2 & n % 2) + n / 2] << (FirstIndex + n + 1) % 2 * 16 >> 16;
            }
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void GetFifo_Packed(int FifoNo, int[] Data, int Count) throws ADwinCommunicationError, IllegalArgumentException, IndexOutOfBoundsException {
        if (Count == 0) {
            return;
        }
        if (Count < 0) {
            throw new IllegalArgumentException(this.LangID == 1 ? "Count must be > 0" : "Count muss > 0 sein");
        }
        if (Data.length < Count) {
            throw new IndexOutOfBoundsException(this.LangID == 1 ? "Data too small" : "Das Data ist zu klein");
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        int RealCount = Count / 2 + Count % 2;
        try {
            int[] IntData = this.add.getFifoInt(FifoNo, RealCount);
            for (int n = 0; n < Count; ++n) {
                Data[n] = IntData[n / 2] << (n + 1) % 2 * 16 >> 16;
            }
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    public int Processor_Type() throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        int ProcessorType = 0;
        try {
            ProcessorType = this.add.getProcessorType();
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        return ProcessorType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void GetData_Int(int DataNo, int[] Data, int FirstIndex, int Count) throws ADwinCommunicationError, IllegalArgumentException, IndexOutOfBoundsException {
        if (Count == 0) {
            return;
        }
        if (Count < 0) {
            throw new IllegalArgumentException(this.LangID == 1 ? "Count must be > 0" : "Count muss > 0 sein");
        }
        if (Data.length < Count) {
            throw new IndexOutOfBoundsException(this.LangID == 1 ? "Data too small" : "Das Data ist zu klein");
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        int[] d = null;
        try {
            d = this.add.getDataInt(DataNo, FirstIndex, FirstIndex + Count - 1);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        System.arraycopy(d, 0, Data, 0, Count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void GetData_Long(int DataNo, int[] Data, int FirstIndex, int Count) throws ADwinCommunicationError, IllegalArgumentException, IndexOutOfBoundsException {
        if (Count == 0) {
            return;
        }
        if (Count < 0) {
            throw new IllegalArgumentException(this.LangID == 1 ? "Count must be > 0" : "Count muss > 0 sein");
        }
        if (Data.length < Count) {
            throw new IndexOutOfBoundsException(this.LangID == 1 ? "Data too small" : "Das Data ist zu klein");
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        int[] d = null;
        try {
            d = this.add.getDataInt(DataNo, FirstIndex, FirstIndex + Count - 1);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        System.arraycopy(d, 0, Data, 0, Count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void GetData_Long(int DataNo, long[] Data, int FirstIndex, int Count) throws ADwinCommunicationError, IllegalArgumentException, IndexOutOfBoundsException {
        if (Count == 0) {
            return;
        }
        if (Count < 0) {
            throw new IllegalArgumentException(this.LangID == 1 ? "Count must be > 0" : "Count muss > 0 sein");
        }
        if (Data.length < Count) {
            throw new IndexOutOfBoundsException(this.LangID == 1 ? "Data too small" : "Das Data ist zu klein");
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        long[] d = null;
        try {
            d = this.add.getDataLong(DataNo, FirstIndex, FirstIndex + Count - 1);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        System.arraycopy(d, 0, Data, 0, Count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void GetData_Long(int DataNo, int[] Data, int FirstIndex, int Count, first_pcarray_index_t FirstArrayIndex) throws ADwinCommunicationError, IllegalArgumentException, IndexOutOfBoundsException {
        if (Count == 0) {
            return;
        }
        if (Count < 0) {
            throw new IllegalArgumentException(this.LangID == 1 ? "Count must be > 0" : "Count muss > 0 sein");
        }
        if (Data.length < Count + FirstArrayIndex.ordinal()) {
            throw new IndexOutOfBoundsException(this.LangID == 1 ? "Data too small" : "Das Data ist zu klein");
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        int[] d = null;
        try {
            d = this.add.getDataInt(DataNo, FirstIndex, FirstIndex + Count - 1);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        System.arraycopy(d, 0, Data, FirstArrayIndex.ordinal(), Count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void GetData_Long(int DataNo, long[] Data, int FirstIndex, int Count, first_pcarray_index_t FirstArrayIndex) throws ADwinCommunicationError, IllegalArgumentException, IndexOutOfBoundsException {
        if (Count == 0) {
            return;
        }
        if (Count < 0) {
            throw new IllegalArgumentException(this.LangID == 1 ? "Count must be > 0" : "Count muss > 0 sein");
        }
        if (Data.length < Count + FirstArrayIndex.ordinal()) {
            throw new IndexOutOfBoundsException(this.LangID == 1 ? "Data too small" : "Das Data ist zu klein");
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        long[] d = null;
        try {
            d = this.add.getDataLong(DataNo, FirstIndex, FirstIndex + Count - 1);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        System.arraycopy(d, 0, Data, FirstArrayIndex.ordinal(), Count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void GetData_Float(int DataNo, float[] Data, int FirstIndex, int Count) throws ADwinCommunicationError, IllegalArgumentException, IndexOutOfBoundsException {
        if (Count == 0) {
            return;
        }
        if (Count < 0) {
            throw new IllegalArgumentException(this.LangID == 1 ? "Count must be > 0" : "Count muss > 0 sein");
        }
        if (Data.length < Count) {
            throw new IndexOutOfBoundsException(this.LangID == 1 ? "Data too small" : "Das Data ist zu klein");
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        float[] d = null;
        try {
            d = this.add.getDataFloat(DataNo, FirstIndex, FirstIndex + Count - 1);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        System.arraycopy(d, 0, Data, 0, Count);
        this.test_float_buffer_qnan(Data, Count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void GetData_Float(int DataNo, float[] Data, int FirstIndex, int Count, first_pcarray_index_t FirstArrayIndex) throws ADwinCommunicationError, IllegalArgumentException, IndexOutOfBoundsException {
        if (Count == 0) {
            return;
        }
        if (Count < 0) {
            throw new IllegalArgumentException(this.LangID == 1 ? "Count must be > 0" : "Count muss > 0 sein");
        }
        if (Data.length < Count + FirstArrayIndex.ordinal()) {
            throw new IndexOutOfBoundsException(this.LangID == 1 ? "Data too small" : "Das Data ist zu klein");
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        float[] d = null;
        try {
            d = this.add.getDataFloat(DataNo, FirstIndex, FirstIndex + Count - 1);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        System.arraycopy(d, 0, Data, FirstArrayIndex.ordinal(), Count);
        this.test_float_buffer_qnan(Data, Count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void GetData_Double(int DataNo, double[] Data, int FirstIndex, int Count) throws ADwinCommunicationError, IllegalArgumentException, IndexOutOfBoundsException {
        if (Count == 0) {
            return;
        }
        if (Count < 0) {
            throw new IllegalArgumentException(this.LangID == 1 ? "Count must be > 0" : "Count muss > 0 sein");
        }
        if (Data.length < Count) {
            throw new IndexOutOfBoundsException(this.LangID == 1 ? "Data too small" : "Das Data ist zu klein");
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        double[] d = null;
        try {
            d = this.add.getDataDouble(DataNo, FirstIndex, FirstIndex + Count - 1);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        System.arraycopy(d, 0, Data, 0, Count);
        this.test_double_buffer_qnan(Data, Count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void GetData_Double(int DataNo, double[] Data, int FirstIndex, int Count, first_pcarray_index_t FirstArrayIndex) throws ADwinCommunicationError, IllegalArgumentException, IndexOutOfBoundsException {
        if (Count == 0) {
            return;
        }
        if (Count < 0) {
            throw new IllegalArgumentException(this.LangID == 1 ? "Count must be > 0" : "Count muss > 0 sein");
        }
        if (Data.length < Count + FirstArrayIndex.ordinal()) {
            throw new IndexOutOfBoundsException(this.LangID == 1 ? "Data too small" : "Das Data ist zu klein");
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        double[] d = null;
        try {
            d = this.add.getDataDouble(DataNo, FirstIndex, FirstIndex + Count - 1);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        System.arraycopy(d, 0, Data, FirstArrayIndex.ordinal(), Count);
        this.test_double_buffer_qnan(Data, Count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SetData_Long(int DataNo, int[] Data, int FirstIndex, int Count) throws ADwinCommunicationError, IllegalArgumentException {
        if (Count <= 0) {
            throw new IllegalArgumentException();
        }
        if (Data.length < Count) {
            throw new IllegalArgumentException();
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            this.add.setDataInt(DataNo, Data, FirstIndex, Count);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SetData_Long(int DataNo, long[] Data, int FirstIndex, int Count) throws ADwinCommunicationError, IllegalArgumentException {
        if (Count <= 0) {
            throw new IllegalArgumentException();
        }
        if (Data.length < Count) {
            throw new IllegalArgumentException();
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            this.add.setDataLong(DataNo, Data, FirstIndex, Count);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SetData_Long(int DataNo, int[] Data, int FirstIndex, int Count, first_pcarray_index_t FirstArrayIndex) throws ADwinCommunicationError, IllegalArgumentException {
        int[] d;
        if (Count <= 0) {
            throw new IllegalArgumentException();
        }
        if (Data.length < Count + FirstArrayIndex.ordinal()) {
            throw new IllegalArgumentException();
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        if (FirstArrayIndex == first_pcarray_index_t.one) {
            d = new int[Count];
            System.arraycopy(Data, 1, d, 0, Count);
        } else {
            d = Data;
        }
        try {
            this.add.setDataInt(DataNo, d, FirstIndex, Count);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SetData_Float(int DataNo, float[] Data, int FirstIndex, int Count) throws ADwinCommunicationError, IllegalArgumentException {
        if (Count <= 0) {
            throw new IllegalArgumentException();
        }
        if (Data.length < Count) {
            throw new IllegalArgumentException();
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            this.add.setDataFloat(DataNo, Data, FirstIndex, Count);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SetData_Float(int DataNo, float[] Data, int FirstIndex, int Count, first_pcarray_index_t FirstArrayIndex) throws ADwinCommunicationError, IllegalArgumentException {
        float[] d;
        if (Count <= 0) {
            throw new IllegalArgumentException();
        }
        if (Data.length < Count + FirstArrayIndex.ordinal()) {
            throw new IllegalArgumentException();
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        if (FirstArrayIndex == first_pcarray_index_t.one) {
            d = new float[Count];
            System.arraycopy(Data, 1, d, 0, Count);
        } else {
            d = Data;
        }
        try {
            this.add.setDataFloat(DataNo, d, FirstIndex, Count);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SetData_Double(int DataNo, double[] Data, int FirstIndex, int Count) throws ADwinCommunicationError, IllegalArgumentException {
        if (Count <= 0) {
            throw new IllegalArgumentException();
        }
        if (Data.length < Count) {
            throw new IllegalArgumentException(this.LangID == 1 ? "Data too small" : "Das Data ist zu klein");
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            this.add.setDataDouble(DataNo, Data, FirstIndex, Count);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SetData_Double(int DataNo, double[] Data, int FirstIndex, int Count, first_pcarray_index_t FirstArrayIndex) throws ADwinCommunicationError, IllegalArgumentException {
        double[] d;
        if (Count <= 0) {
            throw new IllegalArgumentException();
        }
        if (Data.length < Count + FirstArrayIndex.ordinal()) {
            throw new IllegalArgumentException();
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        if (FirstArrayIndex == first_pcarray_index_t.one) {
            d = new double[Count];
            System.arraycopy(Data, 1, d, 0, Count);
        } else {
            d = Data;
        }
        try {
            this.add.setDataDouble(DataNo, d, FirstIndex, Count);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    public void Set_Par(int Index, int Value) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            this.add.setPar(Index, Value);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Get_Par_Block(int[] Array, int FirstIndex, int Count) throws ADwinCommunicationError, IllegalArgumentException {
        if (Count <= 0) {
            throw new IllegalArgumentException();
        }
        if (Array.length < Count) {
            throw new IllegalArgumentException();
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        int[] Params = null;
        try {
            Params = this.add.getParIntBlock(FirstIndex, Count);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        System.arraycopy(Params, 0, Array, 0, Count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Get_Par_Block(int[] Array, int FirstIndex, int Count, first_pcarray_index_t FirstArrayIndex) throws ADwinCommunicationError, IllegalArgumentException {
        if (Count <= 0) {
            throw new IllegalArgumentException();
        }
        if (Array.length < Count + FirstArrayIndex.ordinal()) {
            throw new IllegalArgumentException();
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        int[] Params = null;
        try {
            Params = this.add.getParIntBlock(FirstIndex, Count);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        System.arraycopy(Params, 0, Array, FirstArrayIndex.ordinal(), Count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Get_FPar_Block(float[] Array, int FirstIndex, int Count) throws ADwinCommunicationError, IllegalArgumentException {
        if (Count <= 0) {
            throw new IllegalArgumentException();
        }
        if (Array.length < Count) {
            throw new IllegalArgumentException();
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        float[] Params = null;
        try {
            Params = this.add.getParFloatBlock(FirstIndex, Count);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        System.arraycopy(Params, 0, Array, 0, Count);
        this.test_float_buffer_qnan(Array, Count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Get_FPar_Block(float[] Array, int FirstIndex, int Count, first_pcarray_index_t FirstArrayIndex) throws ADwinCommunicationError, IllegalArgumentException {
        if (Count <= 0) {
            throw new IllegalArgumentException();
        }
        if (Array.length < Count + FirstArrayIndex.ordinal()) {
            throw new IllegalArgumentException();
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        float[] Params = null;
        try {
            Params = this.add.getParFloatBlock(FirstIndex, Count);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        System.arraycopy(Params, 0, Array, FirstArrayIndex.ordinal(), Count);
        this.test_float_buffer_qnan(Array, Count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Get_FPar_Block_Double(double[] Array, int FirstIndex, int Count) throws ADwinCommunicationError, IllegalArgumentException {
        if (Count <= 0) {
            throw new IllegalArgumentException();
        }
        if (Array.length < Count) {
            throw new IllegalArgumentException();
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        double[] Params = null;
        try {
            Params = this.add.getParFloatBlockDouble(FirstIndex, Count);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        System.arraycopy(Params, 0, Array, 0, Count);
        this.test_double_buffer_qnan(Array, Count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Get_FPar_Block_Double(double[] Array, int FirstIndex, int Count, first_pcarray_index_t FirstArrayIndex) throws ADwinCommunicationError, IllegalArgumentException {
        if (Count <= 0) {
            throw new IllegalArgumentException();
        }
        if (Array.length < Count + FirstArrayIndex.ordinal()) {
            throw new IllegalArgumentException();
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        double[] Params = null;
        try {
            Params = this.add.getParFloatBlockDouble(FirstIndex, Count);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        System.arraycopy(Params, 0, Array, FirstArrayIndex.ordinal(), Count);
        this.test_double_buffer_qnan(Array, Count);
    }

    public int Data_Length(int DataNo) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        int Length = 0;
        try {
            Length = this.add.getDataLength(DataNo) - 1;
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        return Length;
    }

    public int Fifo_Empty(int FifoNo) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        int FreeElements = 0;
        try {
            FreeElements = this.add.getFifoFree(FifoNo);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        return FreeElements;
    }

    public int Fifo_Full(int FifoNo) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        int UsedElements = 0;
        try {
            UsedElements = this.add.getFifoUsed(FifoNo);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        return UsedElements;
    }

    public void Fifo_Clear(int FifoNo) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            this.add.clearFifo(FifoNo);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SetFifo_Long(int FifoNo, int[] Data, int Count) throws ADwinCommunicationError, IllegalArgumentException {
        if (Count <= 0) {
            throw new IllegalArgumentException();
        }
        if (Data.length < Count) {
            throw new IllegalArgumentException();
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            this.add.setFifoInt(FifoNo, Count, Data);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SetFifo_Float(int FifoNo, float[] Data, int Count) throws ADwinCommunicationError, IllegalArgumentException {
        if (Count <= 0) {
            throw new IllegalArgumentException();
        }
        if (Data.length < Count) {
            throw new IllegalArgumentException();
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            this.add.setFifoFloat(FifoNo, Count, Data);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SetFifo_Double(int FifoNo, double[] Data, int Count) throws ADwinCommunicationError, IllegalArgumentException {
        if (Count <= 0) {
            throw new IllegalArgumentException();
        }
        if (Data.length < Count) {
            throw new IllegalArgumentException();
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            this.add.setFifoDouble(FifoNo, Count, Data);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    public void Get_Par_All(int[] Array) throws ADwinCommunicationError {
        this.Get_Par_Block(Array, 1, 80);
    }

    public void Get_Par_All(int[] Array, first_pcarray_index_t FirstArrayIndex) throws ADwinCommunicationError {
        this.Get_Par_Block(Array, 1, 80, FirstArrayIndex);
    }

    public void Get_FPar_All(float[] Array) throws ADwinCommunicationError {
        this.Get_FPar_Block(Array, 1, 80);
    }

    public void Get_FPar_All(float[] Array, first_pcarray_index_t FirstArrayIndex) throws ADwinCommunicationError {
        this.Get_FPar_Block(Array, 1, 80, FirstArrayIndex);
    }

    public void Get_FPar_All_Double(double[] Array) throws ADwinCommunicationError {
        this.Get_FPar_Block_Double(Array, 1, 80);
    }

    public void Get_FPar_All_Double(double[] Array, first_pcarray_index_t FirstArrayIndex) throws ADwinCommunicationError {
        this.Get_FPar_Block_Double(Array, 1, 80, FirstArrayIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void GetFifo_Long(int FifoNo, int[] Data, int Count) throws ADwinCommunicationError, IllegalArgumentException, IndexOutOfBoundsException {
        if (Count == 0) {
            return;
        }
        if (Count < 0) {
            throw new IllegalArgumentException(this.LangID == 1 ? "Count must be > 0" : "Count muss > 0 sein");
        }
        if (Data.length < Count) {
            throw new IndexOutOfBoundsException(this.LangID == 1 ? "Data too small" : "Das Data ist zu klein");
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        int[] Dat = null;
        try {
            Dat = this.add.getFifoInt(FifoNo, Count);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        System.arraycopy(Dat, 0, Data, 0, Count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void GetFifo_Float(int FifoNo, float[] Data, int Count) throws ADwinCommunicationError, IllegalArgumentException, IndexOutOfBoundsException {
        if (Count == 0) {
            return;
        }
        if (Count < 0) {
            throw new IllegalArgumentException(this.LangID == 1 ? "Count must be > 0" : "Count muss > 0 sein");
        }
        if (Data.length < Count) {
            throw new IndexOutOfBoundsException(this.LangID == 1 ? "Data too small" : "Das Data ist zu klein");
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        float[] Dat = null;
        try {
            Dat = this.add.getFifoFloat(FifoNo, Count);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        System.arraycopy(Dat, 0, Data, 0, Count);
        this.test_float_buffer_qnan(Data, Count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void GetFifo_Double(int FifoNo, double[] Data, int Count) throws ADwinCommunicationError, IllegalArgumentException, IndexOutOfBoundsException {
        if (Count == 0) {
            return;
        }
        if (Count < 0) {
            throw new IllegalArgumentException(this.LangID == 1 ? "Count must be > 0" : "Count muss > 0 sein");
        }
        if (Data.length < Count) {
            throw new IndexOutOfBoundsException(this.LangID == 1 ? "Data too small" : "Das Data ist zu klein");
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        double[] Dat = null;
        try {
            Dat = this.add.getFifoDouble(FifoNo, Count);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        System.arraycopy(Dat, 0, Data, 0, Count);
        this.test_double_buffer_qnan(Data, Count);
    }

    public float Get_FPar(int Index) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        float fpar = 0.0f;
        try {
            fpar = this.add.getFPar(Index);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        return this.test_float_buffer_qnan(fpar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double Get_FPar_Double(int Index) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        double fpar = 0.0;
        try {
            fpar = this.add.getFParDouble(Index);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        return this.test_double_buffer_qnan(fpar);
    }

    public void Set_FPar(int Index, float Value) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            this.add.setFPar(Index, Value);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Set_FPar_Double(int Index, double Value) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            this.add.setFParDouble(Index, Value);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    public int Workload() throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        int wl = 0;
        try {
            wl = this.add.getWorkload();
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        return wl;
    }

    public int Free_Mem(int Mem_Spec) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        int mem = 0;
        try {
            mem = this.add.getFreeMem(Mem_Spec);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        return mem;
    }

    public void Load_Process(String Filename) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        if (!new File(Filename).isFile()) {
            throw new ADwinCommunicationError("File not Found - " + Filename, "Datei nicht gefunden - " + Filename, this.LangID, 200);
        }
        try {
            this.add.loadProcessFile(Filename);
        }
        catch (FileNotFoundException fnfe) {
            throw new ADwinCommunicationError("File not Found - " + Filename, "Datei nicht gefunden - " + Filename, this.LangID, 200);
        }
        catch (IOException ioe) {
            throw new ADwinCommunicationError("Error when reading " + Filename + "(" + ioe.getMessage() + ")", "Fehler beim Lesen von " + Filename + "(" + ioe.getMessage() + ")", this.LangID, 200);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    public void Start_Process(int ProcessNo) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            this.add.startProcess(ProcessNo);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    public void Stop_Process(int ProcessNo) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            this.add.stopProcess(ProcessNo);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    public void Clear_Process(int ProcessNo) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            this.add.clearProcess(ProcessNo);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    public int Process_Status(int ProcessNo) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        int State2 = 0;
        try {
            State2 = this.add.getProcessState(ProcessNo);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        return State2;
    }

    public void Boot(String Filename) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        int ProcessorInt = this.getProcessorInt(Filename);
        if (ProcessorInt == -1) {
            throw new ADwinCommunicationError("Invalid BTL-File: " + Filename, "Ung\u00fcltige BTL: " + Filename, this.LangID, 204);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            this.add.bootFile(Filename, ProcessorInt);
        }
        catch (FileNotFoundException fnfe) {
            throw new ADwinCommunicationError("File " + Filename + " not found", "Datei " + Filename + " nicht gefunden", this.LangID, 200);
        }
        catch (IOException ioe) {
            throw new ADwinCommunicationError("Error when reading " + Filename + "(" + ioe.getMessage() + ")", "Fehler beim Lesen von " + Filename + "(" + ioe.getMessage() + ")", this.LangID, 205);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    public String GetData_String(int DataNo) throws ADwinCommunicationError {
        String str;
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            str = this.add.getString(DataNo);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int GetData_String(int DataNo, char[] Data, int MaxCount) throws ADwinCommunicationError {
        if (Data.length < MaxCount) {
            return 0;
        }
        int n = 0;
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            String str = this.add.getString(DataNo);
            for (n = 0; n < MaxCount && n < str.length(); ++n) {
                Data[n] = str.charAt(n);
            }
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        return n;
    }

    public void SetData_String(int DataNo, String Data) throws ADwinCommunicationError, IllegalArgumentException {
        if (Data.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            this.add.setString(DataNo, Data);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    public int String_Length(int DataNo) throws ADwinCommunicationError {
        int len;
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            len = this.add.getStringLength(DataNo);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        return len;
    }

    public void Set_Globaldelay(int ProcessNo, int Globaldelay) throws ADwinCommunicationError {
        this.Set_Processdelay(ProcessNo, Globaldelay);
    }

    public void Set_Processdelay(int ProcessNo, int Processdelay) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            this.add.setGlobalDelay(ProcessNo, Processdelay);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    public int Get_Globaldelay(int ProcessNo) throws ADwinCommunicationError {
        return this.Get_Processdelay(ProcessNo);
    }

    public int Get_Processdelay(int ProcessNo) throws ADwinCommunicationError {
        int Globaldelay;
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            Globaldelay = this.add.getGlobalDelay(ProcessNo);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        return Globaldelay;
    }

    public void setDebugListener(ADwinDebugListener adl) {
        this.add.adl = adl;
    }

    public int Test_Version() throws ADwinCommunicationError {
        int RetVal;
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            RetVal = this.add != null ? this.add.test_version() : 3;
        }
        catch (ADwinCommunicationError awce) {
            RetVal = 3;
        }
        if (this.UseFileLocks) {
            this.nm.leave();
        }
        return RetVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void Data2File(String Filename, int DataNo, int Startindex, int Count, int Mode) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        FileOutputStream fos = null;
        if (Mode != 0 && Mode != 1) {
            throw new IllegalArgumentException(this.LangID == 1 ? "Mode must be 0 or 1" : "Mode muss 0 oder 1 sein");
        }
        try {
            fos = new FileOutputStream(Filename, Mode != 0);
        }
        catch (FileNotFoundException fnfe) {
            throw new ADwinCommunicationError("File not Found (" + fnfe.getMessage() + ")", "Datei nicht gefunden (" + fnfe.getMessage() + ")", this.LangID, 200);
        }
        if (Count <= 0) {
            throw new IllegalArgumentException(this.LangID == 1 ? "Count must be > 0" : "Count muss > 0 sein");
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            int DataType = this.add.getDataType(DataNo);
            switch (DataType) {
                case 5: {
                    float[] f = this.add.getDataFloat(DataNo, Startindex, Startindex + Count - 1);
                    byte[] b = new byte[Count * 4];
                    for (int n = 0; n < Count; ++n) {
                        ADwinDirectDevice.setInteger(b, n * 4, Float.floatToIntBits(f[n]));
                    }
                    try {
                        fos.write(b, 0, Count * 4);
                        return;
                    }
                    catch (IOException ioe) {
                        throw new ADwinCommunicationError("Error when writing to file " + Filename, "Fehler beim Schreiben zur Datei " + Filename, this.LangID, 205);
                    }
                }
                case 3: {
                    int[] i = this.add.getDataInt(DataNo, Startindex, Startindex + Count - 1);
                    byte[] b = new byte[Count * 4];
                    for (int n = 0; n < Count; ++n) {
                        ADwinDirectDevice.setInteger(b, n * 4, i[n]);
                    }
                    try {
                        fos.write(b, 0, Count * 4);
                        return;
                    }
                    catch (IOException ioe) {
                        throw new ADwinCommunicationError("Error when writing to file " + Filename, "Fehler beim Schreiben zur Datei " + Filename, this.LangID, 205);
                    }
                }
                default: {
                    throw new ADwinCommunicationError("Invalid Type of Data_" + DataNo, "Data_" + DataNo + " hat einen ung\u00fcltigen Typ", this.LangID, 100);
                }
            }
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
            try {
                fos.close();
            }
            catch (IOException ioe) {
                throw new ADwinCommunicationError("I/O-Error: " + ioe.getMessage(), "E/A-Fehler: " + ioe.getMessage(), this.LangID, 205);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void File2Data(String Filename, int DataType, int DataNo, int Startindex) throws ADwinCommunicationError, IllegalArgumentException {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            byte[] Binary;
            try {
                FileInputStream fis = new FileInputStream(Filename);
                Binary = new byte[fis.available()];
                fis.read(Binary);
                fis.close();
                if (Binary.length == 0) {
                    throw new ADwinCommunicationError("The file is not valid.", "Die Datei ist ung\u00fcltig.", this.LangID, 203);
                }
            }
            catch (FileNotFoundException e) {
                throw new ADwinCommunicationError("File not found.", "Datei konnte nicht gefunden werden.", this.LangID, 200);
            }
            catch (IOException e) {
                throw new ADwinCommunicationError("The file is not valid.", "Die Datei ist ung\u00fcltig.", this.LangID, 203);
            }
            switch (DataType) {
                case 3: {
                    int Count = Binary.length / 4;
                    int[] iData = new int[Count];
                    this.add.convert_data_from_stream_to_int(Binary, iData, Count);
                    this.add.setDataInt(DataNo, iData, 1, Count);
                    return;
                }
                case 5: {
                    int Count = Binary.length / 4;
                    float[] fData = new float[Count];
                    this.add.convert_data_from_stream_to_float(Binary, fData, Count);
                    this.add.setDataFloat(DataNo, fData, 1, Count);
                    return;
                }
                case 6: {
                    int Count = Binary.length / 8;
                    double[] dData = new double[Count];
                    this.add.convert_data_from_stream_to_double(Binary, dData, Count);
                    this.add.setDataDouble(DataNo, dData, 1, Count);
                    return;
                }
                default: {
                    throw new IllegalArgumentException(this.LangID == 2 ? "Als DataType 3, 5 oder 6 angeben!" : "DataType must be 3, 5 or 6!");
                }
            }
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    public int Data_Type(int DataNo) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        int dtype = 0;
        try {
            dtype = this.add.getDataType(DataNo);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
        return dtype;
    }

    public ADwinDevice Get_Copy() {
        ADwinDevice a = new ADwinDevice();
        a.Set_Language(this.LangID);
        try {
            a.Use_FileLocks(this.UseFileLocks);
        }
        catch (ADwinCommunicationError ace) {
            System.out.println(ace.getMessage());
        }
        return a;
    }

    private int getProcessorInt(String Filename) {
        int ProcessorInt = -1;
        String btl = Filename.toLowerCase();
        if (btl.endsWith("adwin121.btl")) {
            return 9;
        }
        char ProcessorChar = btl.charAt(Filename.length() - 5);
        if (ProcessorChar >= '0' && ProcessorChar <= '9') {
            ProcessorInt = ProcessorChar - 48;
        }
        return ProcessorInt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Boot(byte[] File2, String Filename) throws ADwinCommunicationError, IOException {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        int ProcessorInt = this.getProcessorInt(Filename);
        if (ProcessorInt == -1) {
            this.nm.leave();
            throw new ADwinCommunicationError("Invalid BTL-File: " + Filename, "Ung\u00fcltige BTL: " + Filename, this.LangID, 204);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            if (Filename.toLowerCase().endsWith("121.btl")) {
                this.add.bootArrayADwinX(File2, Filename, ProcessorInt);
            } else {
                this.add.bootArray(File2, Filename, ProcessorInt);
            }
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    public void Load_Process(byte[] file, String fileName) throws ADwinCommunicationError {
        if (this.CurrentDeviceNo <= 0) {
            throw new ADwinCommunicationError("No device set yet", "Noch keine Device-Nummer gesetzt", this.LangID, 0);
        }
        if (this.UseFileLocks) {
            this.nm.enter();
        }
        try {
            this.add.loadProcessArray(file, fileName);
        }
        catch (IOException ioe) {
            throw new ADwinCommunicationError("I/O-Error: " + ioe.getMessage(), "E/A-Fehler: " + ioe.getMessage(), this.LangID, 2000);
        }
        finally {
            if (this.UseFileLocks) {
                this.nm.leave();
            }
        }
    }

    public void Boot(URL btl) throws ADwinCommunicationError, IOException {
        this.Boot(this.loadURL(btl), btl.toString());
    }

    public void Load_Process(URL process) throws ADwinCommunicationError {
        this.Load_Process(this.loadURL(process), process.toString());
    }

    private byte[] loadURL(URL url) throws ADwinCommunicationError {
        try {
            int bytesReadThisTime;
            InputStream is = url.openStream();
            byte[] resource = new byte[is.available()];
            int bytesRead = 0;
            do {
                bytesReadThisTime = is.read(resource, bytesRead, resource.length - bytesRead);
                bytesRead += bytesReadThisTime;
            } while (bytesReadThisTime > 0);
            is.close();
            return resource;
        }
        catch (IOException ioe) {
            throw new ADwinCommunicationError("I/O-Error: " + ioe.getMessage(), "E/A-Fehler: " + ioe.getMessage(), this.LangID, 200);
        }
    }

    public void SanitizeFloatingPointValues(int flag) {
        this.NAN_test = flag == 1 ? 1 : 0;
    }

    float test_float_buffer_qnan(float value) {
        if (this.NAN_test == 0) {
            return value;
        }
        if (value == Float.NEGATIVE_INFINITY) {
            return Float.MIN_VALUE;
        }
        if (Float.isNaN(value) || Float.isInfinite(value)) {
            return Float.MAX_VALUE;
        }
        return value;
    }

    void test_float_buffer_qnan(float[] values, int count) {
        if (this.NAN_test == 0) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            if (Float.isNaN(values[i])) {
                values[i] = Float.MAX_VALUE;
            }
            if (values[i] == Float.NEGATIVE_INFINITY) {
                values[i] = Float.MIN_VALUE;
            }
            if (!Float.isNaN(values[i]) && !Float.isInfinite(values[i])) continue;
            values[i] = Float.MAX_VALUE;
        }
    }

    double test_double_buffer_qnan(double value) {
        if (this.NAN_test == 0) {
            return value;
        }
        if (value == Double.NEGATIVE_INFINITY) {
            return Double.MIN_VALUE;
        }
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            return Double.MAX_VALUE;
        }
        return value;
    }

    void test_double_buffer_qnan(double[] values, int count) {
        if (this.NAN_test == 0) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            if (Double.isNaN(values[i])) {
                values[i] = Double.MAX_VALUE;
            }
            if (values[i] == Double.NEGATIVE_INFINITY) {
                values[i] = Double.MIN_VALUE;
            }
            if (!Double.isNaN(values[i]) && !Double.isInfinite(values[i])) continue;
            values[i] = Double.MAX_VALUE;
        }
    }

    public static enum first_pcarray_index_t {
        zero,
        one;

    }

    private static class Dev {
        InetAddress IP;
        String Password;
        int Timeout;
        int ADTimeout;
        int AllowedErrors;
        int WaitTime;
        int Blocksize;
        int NumWaits = 10000000;
        int Hostlink;
        int Port;

        private Dev() {
        }
    }
}

