/*
 * Decompiled with CFR 0.152.
 */
package de.adwin.examples;

import de.adwin.driver.ADwinCommunicationError;
import de.adwin.driver.ADwinDevice;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class Demo
extends JApplet
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = 1L;
    boolean runningAsApplet = false;
    private JTextField fTextfieldIP;
    private JTextField fTextfieldPAR1;
    private JRadioButton fRadioT9;
    private JRadioButton fRadioT10;
    private JRadioButton fRadioT11;
    private JRadioButton fRadioT12;
    private JRadioButton fRadioT121;
    private ADwinDevice fADwin;
    private boolean fADwinBooted;

    @Override
    public void init() {
        this.runningAsApplet = true;
        this.showUIapplet();
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block29: {
            if (e.getActionCommand().equals("boot")) {
                this.fADwinBooted = false;
                try {
                    String basePathName;
                    String ip;
                    if (this.fADwin == null) {
                        this.fADwin = new ADwinDevice();
                    }
                    if ((ip = this.fTextfieldIP.getText()).equals("")) break block29;
                    this.fADwin.Remove_Entry(1);
                    this.fADwin.Add_Entry(1, InetAddress.getByName(ip), "", 1000, 6543, 1200);
                    this.fADwin.Set_DeviceNo(1);
                    if (new File("/etc/adwin/ADWINDIR").exists()) {
                        try {
                            BufferedReader reader = new BufferedReader(new FileReader("/etc/adwin/ADWINDIR"));
                            basePathName = reader.readLine() + "/share/btl/";
                            reader.close();
                        }
                        catch (IOException ioe) {
                            JOptionPane.showMessageDialog(this, "I/O-Error when reading from /etc/adwin/ADWINDIR -\n" + ioe.getMessage(), "Error", 0);
                            return;
                        }
                    } else {
                        basePathName = new File("/opt/adwin/share/btl").exists() ? "/opt/adwin/share/btl/" : "c:\\adwin\\";
                    }
                    try {
                        if (this.fRadioT9.isSelected()) {
                            this.fADwin.Boot(basePathName + "adwin9.btl");
                        } else if (this.fRadioT10.isSelected()) {
                            this.fADwin.Boot(basePathName + "adwin10.btl");
                        } else if (this.fRadioT11.isSelected()) {
                            this.fADwin.Boot(basePathName + "adwin11.btl");
                        } else if (this.fRadioT12.isSelected()) {
                            this.fADwin.Boot(basePathName + "adwin12.btl");
                        } else {
                            this.fADwin.Boot(basePathName + "adwin121.btl");
                        }
                    }
                    catch (ADwinCommunicationError ace) {
                        if (ace.getCode() != 200) {
                            throw ace;
                        }
                        this.bootFromJARFile();
                    }
                    this.fADwinBooted = true;
                }
                catch (UnknownHostException ex) {
                    JOptionPane.showMessageDialog(this, ex, "Error", 0);
                }
                catch (ADwinCommunicationError ex) {
                    JOptionPane.showMessageDialog(this, ex, "Error", 0);
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this, ex, "Error", 0);
                }
                catch (SecurityException ex) {
                    try {
                        this.bootFromJARFile();
                        this.fADwinBooted = true;
                    }
                    catch (ADwinCommunicationError ace) {
                        JOptionPane.showMessageDialog(this, ace, "Error", 0);
                    }
                    catch (IOException ioex) {
                        JOptionPane.showMessageDialog(this, ioex, "Error", 0);
                    }
                }
            } else if (e.getActionCommand().equals("SetPar") && this.fADwinBooted) {
                try {
                    this.fADwin.Set_Par(1, Integer.parseInt(this.fTextfieldPAR1.getText()));
                }
                catch (ADwinCommunicationError ex) {
                    JOptionPane.showMessageDialog(this, "Error when setting PAR_1 - " + ex.getMessage(), "Error", 0);
                    this.fADwinBooted = false;
                }
            }
        }
    }

    void bootFromJARFile() throws ADwinCommunicationError, IOException {
        URL resURL = this.fRadioT9.isSelected() ? this.getClass().getClassLoader().getResource("adwin9.btl") : (this.fRadioT10.isSelected() ? this.getClass().getClassLoader().getResource("adwin10.btl") : (this.fRadioT11.isSelected() ? this.getClass().getClassLoader().getResource("adwin11.btl") : (this.fRadioT12.isSelected() ? this.getClass().getClassLoader().getResource("adwin12.btl") : this.getClass().getClassLoader().getResource("adwin121.btl"))));
        if (resURL == null) {
            JOptionPane.showMessageDialog(this, "BTL files could neither be found on your disk nor in the JAR archive\nPlease check your ADwin installation", "Error", 0);
            return;
        }
        this.fADwin.Boot(resURL);
    }

    private void showUIapplet() {
        Container cp = this.getContentPane();
        this.showUI(cp);
    }

    private void showUIapplication() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setLocation(100, 100);
        frame.setTitle("ADwin Java Demo");
        Container cp = frame.getContentPane();
        this.showUI(cp);
        frame.pack();
        frame.setVisible(true);
    }

    private void showUI(Container cp) {
        this.fADwinBooted = false;
        GridBagLayout gb = new GridBagLayout();
        Insets insets = new Insets(4, 4, 4, 4);
        cp.setLayout(gb);
        JLabel label = new JLabel("IP address");
        cp.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
        this.fTextfieldIP = new JTextField(16);
        cp.add((Component)this.fTextfieldIP, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 1, insets, 0, 0));
        label = new JLabel("Processor");
        cp.add((Component)label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
        JPanel panel = new JPanel();
        this.fRadioT9 = new JRadioButton("T9");
        this.fRadioT9.setActionCommand("T9");
        this.fRadioT9.addActionListener(this);
        this.fRadioT9.setSelected(true);
        panel.add(this.fRadioT9);
        this.fRadioT10 = new JRadioButton("T10");
        this.fRadioT10.setActionCommand("T10");
        this.fRadioT10.addActionListener(this);
        panel.add(this.fRadioT10);
        this.fRadioT11 = new JRadioButton("T11");
        this.fRadioT11.setActionCommand("T11");
        this.fRadioT11.addActionListener(this);
        panel.add(this.fRadioT11);
        this.fRadioT12 = new JRadioButton("T12");
        this.fRadioT12.setActionCommand("T12");
        this.fRadioT12.addActionListener(this);
        panel.add(this.fRadioT12);
        this.fRadioT121 = new JRadioButton("X");
        this.fRadioT121.setActionCommand("T121");
        this.fRadioT121.addActionListener(this);
        panel.add(this.fRadioT121);
        ButtonGroup group = new ButtonGroup();
        group.add(this.fRadioT9);
        group.add(this.fRadioT10);
        group.add(this.fRadioT11);
        group.add(this.fRadioT12);
        group.add(this.fRadioT121);
        cp.add((Component)panel, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        JButton button = new JButton("Boot");
        button.setActionCommand("boot");
        button.addActionListener(this);
        cp.add((Component)button, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 2, insets, 0, 0));
        label = new JLabel("PAR_1");
        cp.add((Component)label, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
        this.fTextfieldPAR1 = new JTextField(10);
        this.fTextfieldPAR1.addFocusListener(this);
        cp.add((Component)this.fTextfieldPAR1, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 1, insets, 0, 0));
        JButton jb = new JButton("Set");
        jb.setActionCommand("SetPar");
        jb.addActionListener(this);
        cp.add((Component)jb, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        DemoTimerTask demott = new DemoTimerTask();
        Timer timer = new Timer();
        timer.schedule((TimerTask)demott, 0L, 1000L);
    }

    public static void main(String[] args) {
        Demo demo = new Demo();
        demo.showUIapplication();
    }

    class DemoTimerTask
    extends TimerTask {
        DemoTimerTask() {
        }

        @Override
        public void run() {
            try {
                if (Demo.this.fADwinBooted && !Demo.this.fTextfieldPAR1.hasFocus()) {
                    Demo.this.fTextfieldPAR1.setText(Integer.toString(Demo.this.fADwin.Get_Par(1)));
                }
            }
            catch (ADwinCommunicationError ex) {
                Demo.this.fADwinBooted = false;
                ex.printStackTrace();
            }
        }
    }
}

